template < int seedStart >
int randm() {
    const int modulus = 1<<16, multiplier = 23477,
                term = 17712;
    static int seed = seedStart;
    seed = (seed * multiplier + term) % modulus;
    return seed;
}
 
// Each of the following function pointers invokes a
// function which starts the random number sequence at a 
// different initial seed value.
int (*ran0)() = randm<62002>;
int (*ran1)() = randm<23917>;
int (*ran2)() = randm<27225>;
int (*ran3)() = randm<42285>;
